Attribute VB_Name = "WhisperController"
Option Explicit

'----------------------------------------------------------
'  Myriad
'  Whisper Window Controller
'----------------------------------------------------------
'  Version 1.3.1 (2005-02-06)
'  1.0.0: Module added. (Cloaked)
'----------------------------------------------------------

'----------------------------------------------------------
'  Settings
'----------------------------------------------------------
Public useWhisperWindows As Boolean

'----------------------------------------------------------
'  Window Collection
'----------------------------------------------------------
Private WhisperWindows As Collection


'----------------------------------------------------------
'  Initializer
'----------------------------------------------------------
Public Sub WC_Initialize()
    Set WhisperWindows = New Collection
    useWhisperWindows = GetBoolean("UseWhisperWindows", "Behavior")
End Sub

Public Sub HandleWhisperReceived(Username As String, Message As String)
On Error GoTo HWR_Error
    Dim IsFriendUpdate As Boolean
    IsFriendUpdate = (Left$(Message, 12) = "Your friend ")
    
    If (IsFriendUpdate And Not WhisperWindowExists(Username)) Or Not useWhisperWindows Or InTray Then
        AddC_SCColors "<From: " & Username & "> ", WhisperBlue, Message, vbSilver
        If InTray Then _
            ShowNotification "Whisper From " & Username, Message, niInfo
        Exit Sub
    End If
    
    WhisperWindows(Username).AddMessage evWhisperRecv, Message
    Exit Sub
HWR_Error:
    CreateWhisperWindow Username, Message
End Sub

Public Sub HandleWhisperSent(Username As String, Message As String)
On Error GoTo HWS_Error
    If Not useWhisperWindows Or InTray Then
        AddC_SCColors "<To: " & Username & "> ", WhisperBlue, Message, vbSilver
        Exit Sub
    End If
    
    WhisperWindows(Username).AddMessage evWhisperSend, Message
    Exit Sub
HWS_Error:
    CreateWhisperWindow Username, Message, evWhisperSend
End Sub

Public Sub CreateWhisperWindow(Username As String, _
    Optional Message As String = vbNullString, _
    Optional ByVal EventType As bnEvent = evWhisperRecv)
    
    Dim WW As frmWhisper
    Set WW = New frmWhisper
    WW.Initialize Username, Message, EventType
    WhisperWindows.Add WW, Username
End Sub

Public Sub WhisperWindow_Destroyed(Username As String)
    WhisperWindows.Remove Username
End Sub

Private Function WhisperWindowExists(Username As String)
On Error GoTo Trap
    Dim Wnd As frmWhisper
    Set Wnd = WhisperWindows(Username)
    WhisperWindowExists = True
    Exit Function
Trap:
    WhisperWindowExists = False
End Function
